//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Data
{
//+----------------+
    private:
//+----------------+
        double Values[];
//+----------------+
    public:
//+----------------+
        void Set(const double &arg[])
        {
            ArrayCopy(Values, arg);
        }
//+----------------+
        double Average(void)
        {
            double sum = 0;

            for (uint c = 0; c < Values.Size(); c++)
                sum += Values[c];

            return sum / Values.Size();
        }
//+----------------+
        double Median(void)
        {
            double  Tmp[];

            ArrayCopy(Tmp, Values);
            ArraySort(Tmp);
            if (!(Tmp.Size() & 1))
            {
                int i = (int)MathFloor(Tmp.Size() / 2);

                return (Tmp[i] + Tmp[i - 1]) / 2.0;
            }
            return Tmp[Tmp.Size() / 2];
        }
//+----------------+
};
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => ", X)
//+------------------------------------------------------------------+
void OnStart(void)
{
    const double H[] = {2.05, 1.97, 1.87, 1.75, 1.99, 2.01, 1.83};
    const double K[] = {12, 4, 7, 23, 38};

    st_Data Info;

    Info.Set(H);
    PrintX(Info.Average());

    ArrayPrint(Info.Values, 2);
    ZeroMemory(Info);
    ArrayCopy(Info.Values, K);

    PrintX(Info.Median());

    ArrayPrint(Info.Values, 2);
}
//+------------------------------------------------------------------+